/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.modelo.util;

import ec.gob.sri.dimm.api.logger.PluginLogger;
import ec.gob.sri.dimm.ats.modelo.util.Constantes;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.joda.time.DateTime;
import org.joda.time.IllegalFieldValueException;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class Util {
    private static final Calendar FECHA_UNO = new GregorianCalendar();
    private static final Calendar FECHA_DOS = new GregorianCalendar();
    public static final int MAYOR_QUE = 1;
    public static final int MENOR_QUE = -1;
    public static final int IGUAL_QUE = 0;

    public static Integer getInteger(String valor) {
        return new Integer(valor);
    }

    public static BigDecimal getBigDecimal(String valor) {
        return new BigDecimal(valor);
    }

    public static Double getDouble(String valor) {
        return Double.parseDouble(valor);
    }

    public static BigDecimal getPorcentaje(BigDecimal base, BigDecimal pct) {
        return base.multiply(pct).divide(Constantes.CIEN, 2, RoundingMode.HALF_EVEN);
    }

    public static boolean isFechasIgualesMesAnio(Date fecha, Calendar periodoFiscal) {
        FECHA_UNO.setTime(fecha);
        return FECHA_UNO.get(2) == periodoFiscal.get(2) && FECHA_UNO.get(1) == periodoFiscal.get(1);
    }

    public static boolean isFechaMenorIgualPeriodoMesAnio(Date fecha, Calendar periodoFiscal) {
        FECHA_UNO.setTime(fecha);
        FECHA_UNO.set(5, 1);
        periodoFiscal.set(5, 1);
        Util.limpiarInformacionTiempo(FECHA_UNO);
        Util.limpiarInformacionTiempo(periodoFiscal);
        return FECHA_UNO.compareTo(periodoFiscal) <= 0;
    }

    public static boolean isAnioMenorIgualPeriodo(String anio, Calendar periodoFiscal) {
        String anioFiscal = String.valueOf(periodoFiscal.get(1));
        return anio.compareTo(anioFiscal) <= 0;
    }

    public static boolean isFechaMayorIgualPeriodoMesAnio(Date fecha, Calendar periodoFiscal) {
        FECHA_UNO.setTime(fecha);
        FECHA_UNO.set(5, 1);
        periodoFiscal.set(5, 1);
        Util.limpiarInformacionTiempo(FECHA_UNO);
        Util.limpiarInformacionTiempo(periodoFiscal);
        return FECHA_UNO.compareTo(periodoFiscal) >= 0;
    }

    public static boolean isFechaMayorIgual(Date fechaUno, Date fechaDos) {
        FECHA_UNO.setTime(fechaUno);
        FECHA_DOS.setTime(fechaDos);
        Util.limpiarInformacionTiempo(FECHA_UNO);
        Util.limpiarInformacionTiempo(FECHA_DOS);
        return FECHA_UNO.compareTo(FECHA_DOS) >= 0;
    }

    public static boolean isFechaMenorIgual(Date fechaUno, Date fechaDos) {
        FECHA_UNO.setTime(fechaUno);
        FECHA_DOS.setTime(fechaDos);
        Util.limpiarInformacionTiempo(FECHA_UNO);
        Util.limpiarInformacionTiempo(FECHA_DOS);
        return FECHA_UNO.compareTo(FECHA_DOS) <= 0;
    }

    public static boolean isFechaMenorUnAnio(Date fechaUno, Date fechaDos) {
        FECHA_UNO.setTime(fechaUno);
        FECHA_DOS.setTime(fechaDos);
        FECHA_DOS.add(1, -1);
        Util.limpiarInformacionTiempo(FECHA_UNO);
        Util.limpiarInformacionTiempo(FECHA_DOS);
        return FECHA_DOS.before(FECHA_UNO);
    }

    private static void limpiarInformacionTiempo(Calendar fecha) {
        fecha.set(11, 0);
        fecha.set(12, 0);
        fecha.set(13, 0);
        fecha.set(14, 0);
    }

    public static BigDecimal sumar(String valorUno, String valorDos) {
        return Util.getBigDecimal(valorUno).add(Util.getBigDecimal(valorDos));
    }

    public static BigDecimal sumarValores(String ... valores) {
        BigDecimal totalSuma = BigDecimal.ZERO;
        String[] stringArray = valores;
        int n = valores.length;
        int n2 = 0;
        while (n2 < n) {
            String valor = stringArray[n2];
            totalSuma = totalSuma.add(Util.getBigDecimal(valor));
            ++n2;
        }
        return totalSuma;
    }

    public static boolean isMargenErrorMasMenos(BigDecimal valorBase, String valorNuevo, BigDecimal margenError) {
        return Util.getBigDecimal(valorNuevo).compareTo(valorBase.subtract(margenError)) >= 0 && Util.getBigDecimal(valorNuevo).compareTo(valorBase.add(margenError)) <= 0;
    }

    public static boolean isSoloCeros(String valor) {
        return valor.replaceAll("0", " ").trim().isEmpty();
    }

    public static String getCadenaFormateada(String valor, String longitud, Character exp) {
        return String.format("%" + longitud + "s", valor.trim().replaceAll("\\s+", "")).replace(' ', exp.charValue());
    }

    public static String dateToStringWithFormat(Date fecha, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        if (fecha == null) {
            return "";
        }
        return sdf.format(fecha);
    }

    public static boolean importarBooleano(Element elemento) {
        return "SI".equals(elemento.getTextContent().trim());
    }

    public static Date importarFecha(Element elementoFecha) {
        try {
            DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
            DateTime dt = formatter.parseDateTime(elementoFecha.getTextContent());
            return dt.toDate();
        }
        catch (DOMException e) {
            PluginLogger.logError((String)"Error al extraer el valor del elemento de fecha.", (String)"ec.gob.sri.dimm.ats.modelo", (Exception)e);
        }
        catch (IllegalFieldValueException e) {
            PluginLogger.logError((String)"Error al analizar el valor a convertir en fecha.", (String)"ec.gob.sri.dimm.ats.modelo", (Exception)((Object)e));
            throw new RuntimeException("Error al analizar el valor a convertir en fecha. Campo: '" + elementoFecha.getNodeName() + "'; Valor:'" + elementoFecha.getTextContent() + "'");
        }
        return null;
    }

    public static boolean existeElementoImportar(Element elemento, String tag) {
        return elemento.getElementsByTagName(tag).getLength() > 0;
    }

    public static File guardarArchivo(String directorio, String nombreArchivo, String contenido) {
        OutputStreamWriter oos = null;
        File archivo = null;
        try {
            try {
                archivo = new File(directorio, nombreArchivo);
                oos = new OutputStreamWriter(new FileOutputStream(archivo));
                oos.write(contenido);
            }
            catch (IOException ioe) {
                throw new RuntimeException("guardarArchivo()::directorio" + directorio, ioe);
            }
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            oos = null;
            contenido = null;
        }
        return archivo;
    }

    public static String obtenerRutaBajoDimmHome(String nombreCarpeta) {
        String dir1 = String.valueOf(File.separator) + ".dimmData";
        nombreCarpeta = String.valueOf(File.separator) + nombreCarpeta;
        String userHome = System.getProperty("user.home");
        String rutaCompleta = String.valueOf(userHome) + dir1;
        File folder = new File(rutaCompleta);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(folder = new File(rutaCompleta = String.valueOf(rutaCompleta) + nombreCarpeta)).exists()) {
            folder.mkdir();
        }
        return rutaCompleta;
    }

    public static void moveFile(String rutaDestino, String nuevoNombre, File origen) throws IOException {
        int len;
        rutaDestino = String.valueOf(rutaDestino) + File.separator + nuevoNombre;
        File destino = new File(rutaDestino);
        FileInputStream forgis = new FileInputStream(origen);
        FileOutputStream fdesos = new FileOutputStream(destino);
        int bufferSize = 1024;
        byte[] buf = new byte[bufferSize];
        while ((len = ((InputStream)forgis).read(buf)) > 0) {
            ((OutputStream)fdesos).write(buf, 0, len);
        }
        ((InputStream)forgis).close();
        ((OutputStream)fdesos).close();
        if (!origen.delete()) {
            throw new IOException("No se puede eliminar el archivo de origen ");
        }
    }
}

